<?php
/**
 * 🌟 STELLAZODIACO™ - VERSIONE SENZA EMAIL DUPLICATA
 * Google Apps Script gestisce le email, PHP solo Stripe
 */

// Attiva log errori
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// ✅ CONFIGURAZIONE
$stripe_secret_key = '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';
$GOOGLE_SCRIPT_URL = 'https://script.google.com/macros/s/AKfycbxod_04QhV1jHCeOk5g4nW1KDC4tn9I0Edyimr5y6Mwyve0SEO9bO29OffLjxElMRIx/exec';

try {
    // Leggi input
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    if (!$data) {
        $data = $_POST;
    }
    
    error_log('📝 Dati ricevuti: ' . print_r($data, true));
    
    $action = $data['action'] ?? 'create_payment_intent';
    
    if ($action === 'create_payment_intent') {
        
        // Dati base
        $email = $data['email'] ?? '';
        $nome = $data['nome'] ?? $data['firstName'] ?? '';
        $cognome = $data['cognome'] ?? $data['lastName'] ?? '';
        $segno_zodiacale = $data['segno_zodiacale'] ?? '';
        $amount = (float)($data['amount'] ?? $data['prezzo_totale'] ?? 39.90) * 100; // in centesimi
        
        if (empty($email)) {
            throw new Exception("Email è obbligatoria");
        }
        
        // ✅ CHIAMA STRIPE VIA CURL
        $stripe_data = [
            'amount' => $amount,
            'currency' => 'eur',
            'description' => 'StellaZodiaco™ Kit Zodiacale' . ($segno_zodiacale ? ' - ' . $segno_zodiacale : ''),
            'metadata[product_name]' => 'StellaZodiaco™ Kit Zodiacale',
            'metadata[customer_name]' => trim($nome . ' ' . $cognome),
            'metadata[customer_email]' => $email,
            'metadata[zodiac_sign]' => $segno_zodiacale,
            'metadata[order_source]' => 'stellazodiaco_checkout'
        ];
        
        $ch = curl_init('https://api.stripe.com/v1/payment_intents');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($stripe_data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $stripe_secret_key,
            'Content-Type: application/x-www-form-urlencoded'
        ]);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code !== 200) {
            throw new Exception("Stripe Error: HTTP $http_code - $response");
        }
        
        $paymentIntent = json_decode($response, true);
        
        if (!$paymentIntent || !isset($paymentIntent['client_secret'])) {
            throw new Exception("Invalid Stripe response: $response");
        }
        
        error_log('✅ Payment Intent creato: ' . $paymentIntent['id']);
        
        echo json_encode([
            'success' => true,
            'client_secret' => $paymentIntent['client_secret'],
            'payment_intent_id' => $paymentIntent['id']
        ]);
        
    } elseif ($action === 'payment_success') {
        
        $payment_intent_id = $data['payment_intent_id'] ?? '';
        
        if (empty($payment_intent_id)) {
            throw new Exception('Payment Intent ID mancante');
        }
        
        // ✅ VERIFICA PAYMENT INTENT SU STRIPE VIA CURL
        $ch = curl_init("https://api.stripe.com/v1/payment_intents/$payment_intent_id");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $stripe_secret_key
        ]);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code !== 200) {
            throw new Exception("Stripe Verification Error: HTTP $http_code");
        }
        
        $paymentIntent = json_decode($response, true);
        
        if ($paymentIntent['status'] !== 'succeeded') {
            throw new Exception('Pagamento non completato. Stato: ' . $paymentIntent['status']);
        }
        
        error_log('✅ Pagamento verificato: ' . $payment_intent_id);
        
        // Prepara dati per Google Apps Script
        $customer_data = $data['customer_data'] ?? [];
        
        $order_data = [
            'nome_cliente' => $customer_data['nome'] ?? $customer_data['firstName'] ?? $paymentIntent['metadata']['customer_name'] ?? 'N/D',
            'cognome_cliente' => $customer_data['cognome'] ?? $customer_data['lastName'] ?? '',
            'email_cliente' => $customer_data['email'] ?? $paymentIntent['metadata']['customer_email'] ?? 'N/D',
            'telefono_cliente' => $customer_data['telefono'] ?? $customer_data['phone'] ?? 'N/D',
            'indirizzo_cliente' => $customer_data['indirizzo'] ?? 'N/D',
            'prodotto' => 'StellaZodiaco™ Kit Zodiacale' . ($customer_data['segno_zodiacale'] ? ' - ' . $customer_data['segno_zodiacale'] : ''),
            'segno_zodiacale' => $customer_data['segno_zodiacale'] ?? $paymentIntent['metadata']['zodiac_sign'] ?? 'N/D',
            'quantita' => '1',
            'prezzo_unitario' => '39.90',
            'prezzo_totale' => number_format($paymentIntent['amount'] / 100, 2, '.', ''),
            'modalita_pagamento' => 'STRIPE',
            'stripe_charge_id' => $payment_intent_id,
            'stripe_payment_status' => $paymentIntent['status'],
            'timestamp' => date('c')
        ];
        
        // ✅ INVIA SOLO A GOOGLE APPS SCRIPT (che gestirà le email)
        $google_success = inviaAGoogleAppsScript($order_data, $GOOGLE_SCRIPT_URL);
        
        // ❌ NON INVIARE EMAIL DAL PHP (evita duplicati)
        // $email_success = inviaEmailConferma($order_data, $EMAIL_DESTINATARIO);
        
        error_log('📊 Google Apps Script: ' . ($google_success ? 'OK' : 'ERRORE'));
        
        echo json_encode([
            'success' => true,
            'payment_intent_id' => $payment_intent_id,
            'order_data' => $order_data,
            'google_script_sent' => $google_success,
            'email_sent' => true, // Google Apps Script gestisce le email
            'message' => 'Pagamento completato e notifiche inviate via Google Apps Script'
        ]);
        
    } else {
        throw new Exception('Azione non riconosciuta: ' . $action);
    }
    
} catch (Exception $e) {
    error_log('❌ Errore: ' . $e->getMessage());
    
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'file' => $e->getFile() ?? '',
        'line' => $e->getLine() ?? ''
    ]);
}

/**
 * Invia dati a Google Apps Script (che gestisce email e sheets)
 */
function inviaAGoogleAppsScript($order_data, $script_url) {
    try {
        error_log('📤 Invio a Google Apps Script (gestisce tutto)...');
        
        $post_data = http_build_query($order_data);
        
        $context = stream_context_create([
            'http' => [
                'method' => 'POST',
                'header' => 'Content-Type: application/x-www-form-urlencoded',
                'content' => $post_data,
                'timeout' => 10
            ]
        ]);
        
        $result = file_get_contents($script_url, false, $context);
        error_log('📤 Google Apps Script risposta: ' . $result);
        
        return $result !== false;
        
    } catch (Exception $e) {
        error_log('❌ Google Apps Script errore: ' . $e->getMessage());
        return false;
    }
}

?>